<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../class.php';

$connect = db_connect();

$amount = isset($_GET['amount']) ? (int)$_GET['amount'] : 0;
$chat   = isset($_GET['chat'])   ? preg_replace('/[^0-9]/', '', $_GET['chat']) : '';

if ($amount <= 0 || empty($chat)) {
    http_response_code(400);
    exit('Invalid parameters.');
}

$datas = base64_encode($amount . '|' . $chat); // kept for backward compatibility only

$data = [
    "merchant_id"  => PAYMENT_MERCHANT_ID,
    "amount"       => $amount . "0",
    // Prefer authority-based verification; keep legacy data param for now
    "callback_url" => (PAYMENT_CALLBACK_BASE ?: ((isset($_SERVER['REQUEST_SCHEME']) ? $_SERVER['REQUEST_SCHEME'] : 'https') . '://' . $_SERVER['HTTP_HOST'])) . "/api/verifyz.php?data={$datas}",
    "description"  => "خرید",
    "metadata"     => [ "email" => "info@email.com", "mobile" => "09121234567" ],
];

$jsonData = json_encode($data);
$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($jsonData)]);

$result = json_decode(curl_exec($ch), true);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    echo "cURL Error #:" . htmlspecialchars($err, ENT_QUOTES, 'UTF-8');
    exit;
}

if (empty($result['errors']) && isset($result['data']['code']) && (int)$result['data']['code'] === 100) {
    $authority = $result['data']['authority'] ?? null;
    if ($authority) {
        // Ensure table exists
        $connect->query("CREATE TABLE IF NOT EXISTS pending_payments (id INT AUTO_INCREMENT PRIMARY KEY, authority VARCHAR(255) UNIQUE, chat_id BIGINT, amount INT, status ENUM('pending','paid','failed') DEFAULT 'pending', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        $stmt = $connect->prepare("INSERT INTO pending_payments (authority, chat_id, amount, status) VALUES (?, ?, ?, 'pending') ON DUPLICATE KEY UPDATE chat_id=VALUES(chat_id), amount=VALUES(amount)");
        $stmt->bind_param('sii', $authority, $chat, $amount);
        $stmt->execute();
        $stmt->close();
    }
    header('Location: https://www.zarinpal.com/pg/StartPay/' . $result['data']["authority"]);
    exit;
}

$error_code = $result['errors']['code'] ?? 'Unknown';
$error_message = $result['errors']['message'] ?? 'An unknown error occurred.';
echo 'Error Code: ' . htmlspecialchars($error_code, ENT_QUOTES, 'UTF-8') . '<br>';
echo 'Message: ' .  htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8');
