<?php
require_once __DIR__ . '/includes/auth.php';
require_once 'config.php';

if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: admin.php');
    exit;
}

$error = '';
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $csrf = $_POST['csrf_token'] ?? '';

    if (!hash_equals($_SESSION['csrf_token'] ?? '', $csrf)) {
        $error = 'توکن امنیتی نامعتبر است. لطفاً دوباره تلاش کنید.';
    } elseif ($username === ADMIN_USERNAME && ADMIN_PASSWORD_HASH !== '' && password_verify($password, ADMIN_PASSWORD_HASH)) {
        $_SESSION['admin_logged_in'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $error = 'نام کاربری یا کلمه عبور اشتباه است.';
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به پنل مدیریت</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="assets/styles.css?v=2.1">
</head>
<body class="glass flex items-center justify-center min-h-screen px-4">
    <div class="w-full max-w-md bg-white p-8">
        <div class="text-center mb-8">
            <i class="fas fa-robot text-5xl text-indigo-300"></i>
            <h2 class="text-3xl font-bold text-center mt-4">ورود به پنل مدیریت</h2>
        </div>
        
        <?php if ($error): ?>
            <div class="bg-red-500/30 text-red-300 text-center p-3 rounded-lg mb-6">
                <p><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></p>
            </div>
        <?php endif; ?>

        <form method="POST" action="login.php" class="space-y-6">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" />
            <div class="relative">
                <i class="fa fa-user absolute right-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input type="text" name="username" placeholder="نام کاربری" class="w-full py-3 px-4 pr-11 leading-tight focus:outline-none placeholder-slate-400" required>
            </div>
            <div class="relative">
                <i class="fa fa-lock absolute right-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input type="password" name="password" placeholder="کلمه عبور" class="w-full py-3 px-4 pr-11 leading-tight focus:outline-none placeholder-slate-400" required>
            </div>
            <div>
                <button type="submit" class="bg-gradient-to-r from-cyan-500 to-violet-600 hover:from-cyan-600 hover:to-violet-700 text-white font-bold py-3 px-4 rounded-lg focus:outline-none w-full transition-all duration-300 shadow-lg hover:shadow-violet-500/50">
                    ورود
                </button>
            </div>
        </form>
    </div>
</body>
</html>
