<?php
require_once __DIR__ . '/../config.php';


function request($url, $method = 'GET', $postFields = null, $cookieFile = null, $headers = []) {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => strtoupper($method),
        CURLOPT_SSL_VERIFYPEER => !DISABLE_SSL_VERIFY,  // 🔥 این دو خط
        CURLOPT_SSL_VERIFYHOST => (DISABLE_SSL_VERIFY ? 0 : 2),  // 🔥 رو اضافه کن
    ));

    if (!empty($postFields)) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postFields);
    }

    if ($cookieFile) {
        curl_setopt($curl, CURLOPT_COOKIEJAR, $cookieFile);
        curl_setopt($curl, CURLOPT_COOKIEFILE, $cookieFile);
    }

    if (!empty($headers)) {
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    }

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error = curl_error($curl);
        curl_close($curl);
        return "cURL Error: " . $error;
    }

    curl_close($curl);
    return $response;
}


function login($link,$username, $password, $cookiePath = 'cookie.txt') {
    $url = "$link/login";
    $postData = http_build_query([
        'username' => $username,
        'password' => $password
    ]);

    $headers = [
        'Content-Type: application/x-www-form-urlencoded',
        'Accept: application/json'
    ];

    $response = request($url, 'POST', $postData, $cookiePath, $headers);
    return $response;
}


function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        random_int(0, 0xffff), random_int(0, 0xffff), random_int(0, 0xffff),
        random_int(0, 0x0fff) | 0x4000,
        random_int(0, 0x3fff) | 0x8000,
        random_int(0, 0xffff), random_int(0, 0xffff), random_int(0, 0xffff)
    );
}

function randomString($length = 10) {
    return substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, $length);
}

function gbToBytes($gb) {
    return $gb * 1024 * 1024 * 1024;
}

function daysToTimestamp($days) {
    return (time() + ($days * 86400)) * 1000; // به میلی‌ثانیه
}


function addClientToInbound(
    int $totalGB,
    int $days,
    string $url,
    int $inboundId = 1,
    string $cookiePath = 'cookie.txt'
): string {
        $uuid = generateUUID();
    $email = randomString(15);
    $totalBytes = $totalGB * 1024 * 1024 * 1024;
    $expiryTime = daysToTimestamp($days);
    $url=$url."/panel/api/inbounds/addClient";
    $settings = json_encode([
        "clients" => [
            [
                "id" => $uuid,
                "alterId" => 0,
                "email" => $email,
                "limitIp" => 5,
                "totalGB" => $totalBytes,
                "expiryTime" => $expiryTime,
                "enable" => true,
                "tgId" => "",
                "subId" => ""
            ]
        ]
    ]);

    $postData = json_encode([
        "id" => $inboundId,
        "settings" => $settings
    ]);

    $headers = [
        'Accept: application/json',
        'Content-Type: application/json'
    ];

     $decodedResponse=json_decode(request($url, 'POST', $postData, $cookiePath, $headers),true);
        $output = [
        "remark" => $email,
        "uuid"=>$uuid,
        "response" => $decodedResponse
    ];

    // خروجی به صورت JSON
    header('Content-Type: application/json');
    return json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
function UpdateClient($uuid,$name,
    int $totalGB,
    int $days,
    string $url,
    int $inboundId = 1,
    string $cookiePath = 'cookie.txt'
): string {
    $totalBytes = $totalGB * 1024 * 1024 * 1024;
    $expiryTime = $days;
    $url=$url."/panel/api/inbounds/updateClient/$uuid";
    $settings = json_encode([
        "clients" => [
            [
                "id" => $uuid,
                "alterId" => 0,
                "email" => $name,
                "limitIp" => 5,
                "totalGB" => $totalBytes,
                "expiryTime" => $expiryTime,
                "enable" => true,
                "tgId" => "",
                "subId" => ""
            ]
        ]
    ]);

    $postData = json_encode([
        "id" => $inboundId,
        "settings" => $settings
    ]);

    $headers = [
        'Accept: application/json',
        'Content-Type: application/json'
    ];

    $decodedResponse = json_decode(request($url, 'POST', $postData, $cookiePath, $headers), true);
    $output = [
        "remark" => $name,
        "uuid" => $uuid,
        'exp' => $expiryTime,
        "response" => $decodedResponse
    ];

    // خروجی به صورت JSON
    header('Content-Type: application/json');
    return json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
function ResetClientTraffic(string $email, int $inboundId, string $url, string $cookiePath = 'cookie.txt'): string
{
    // ساخت URL کامل برای درخواست
    $url = rtrim($url, '/') . "/panel/api/inbounds/{$inboundId}/resetClientTraffic/{$email}";

    // هدرها
    $headers = [
        'Accept: application/json',
        'Content-Type: application/json'
    ];

    // ارسال درخواست با استفاده از تابع کمکی request (فرض بر این است که این تابع مثل پروژه قبلی‌تان وجود دارد)
    $response = request($url, 'POST', null, $cookiePath, $headers);
    $decodedResponse = json_decode($response, true);

    // آماده‌سازی خروجی
    $output = [
        "email" => $email,
        "inboundId" => $inboundId,
        "response" => $decodedResponse
    ];

    // خروجی به صورت JSON
    header('Content-Type: application/json');
    return json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
function DeleteClient(string $uuid, int $inboundId, string $url, string $cookiePath = 'cookie.txt'): string
{
    // ساخت URL نهایی برای درخواست حذف
    $url = rtrim($url, '/') . "/panel/api/inbounds/{$inboundId}/delClient/{$uuid}";

    // هدرها
    $headers = [
        'Accept: application/json',
        'Content-Type: application/json'
    ];

    // ارسال درخواست POST با استفاده از تابع request
    $response = request($url, 'POST', null, $cookiePath, $headers);
    $decodedResponse = json_decode($response, true);

    // خروجی آماده
    $output = [
        "uuid" => $uuid,
        "inboundId" => $inboundId,
        "response" => $decodedResponse
    ];

    // خروجی JSON با فرمت خوانا
    header('Content-Type: application/json');
    return json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}

function getEmailStats($email, $data) {
    // بررسی می‌کنیم که آیا 'clientStats' داخل داده موجود است
    if (isset($data['clientStats']) && is_array($data['clientStats'])) {
        // Loop through each email in the clientStats
        foreach ($data['clientStats'] as $client) {
            // اگر ایمیل با ایمیل مورد نظر تطابق داشت
            if ($client['email'] === $email) {
                // برگرداندن اطلاعات مورد نظر در قالب یک آرایه
                return [
                    'id' => $client['id'],
                    'inboundId' => $client['inboundId'],
                    'enable' => $client['enable'],
                    'email' => $client['email'],
                    'up' => $client['up'],
                    'down' => $client['down'],
                    'expiryTime' => $client['expiryTime'],
                    'total' => $client['total'],
                    'reset' => $client['reset']
                ];
            }
        }
    }

    // در صورتی که ایمیل پیدا نشد
    return null;
}
function getClientTraffic($link,$email, $cookiePath = 'cookie.txt') {
    // ساخت URL بر اساس ایمیل
    $url = "$link/panel/api/inbounds/getClientTraffics/" . $email;

    // هدرهایی که باید به درخواست اضافه شوند
    $headers = [
        'Accept: application/json'
    ];

    // ارسال درخواست با استفاده از تابع request (مشابه با درخواست‌های قبلی)
    $response = request($url, 'GET', null, $cookiePath, $headers);

    // بازگشت پاسخ دریافت شده
    return $response;
}

function getClientTrafficById($link, $uuid, $cookiePath = 'cookie.txt') {
    $url = rtrim($link, '/') . "/panel/api/inbounds/getClientTrafficsById/" . $uuid;

    $headers = [
        'Accept: application/json'
    ];

    return request($url, 'GET', null, $cookiePath, $headers);
}
function getPortById($id,  $baseUrl, $cookiePath = 'cookie.txt') {
    $url = rtrim($baseUrl, '/') . '/panel/api/inbounds/list';

    $headers = [
        'Accept: application/json'
    ];

    $response = request($url, 'GET', null, $cookiePath, $headers);
    $data = json_decode($response, true);

    if (!isset($data['obj']) || !is_array($data['obj'])) {
        return json_encode([
            'status' => false,
            'msg' => 'Invalid response from server',
            'status_code' => 500
        ]);
    }

    foreach ($data['obj'] as $value) {
        if ($value['id'] == $id) {
            return json_encode([
                'status' => true,
                'port' => $value['port'],
                'status_code' => 200
            ]);
        }
    }

    return json_encode([
        'status' => false,
        'msg' => 'ID not found',
        'status_code' => 404
    ]);
}