<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../class.php'; // for sendmessage and db schema assumptions

$connect = db_connect();

// Authority is required
$authority = isset($_GET['Authority']) ? $_GET['Authority'] : null;
if (!$authority) {
    http_response_code(400);
    exit('Missing Authority.');
}

// Ensure table exists and fetch pending record
$connect->query("CREATE TABLE IF NOT EXISTS pending_payments (id INT AUTO_INCREMENT PRIMARY KEY, authority VARCHAR(255) UNIQUE, chat_id BIGINT, amount INT, status ENUM('pending','paid','failed') DEFAULT 'pending', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
$stmt0 = $connect->prepare("SELECT chat_id, amount, status FROM pending_payments WHERE authority = ? LIMIT 1");
$stmt0->bind_param('s', $authority);
$stmt0->execute();
$res0 = $stmt0->get_result();
$pending = $res0->fetch_assoc();
$stmt0->close();

if (!$pending) {
    http_response_code(400);
    exit('No pending record for this authority.');
}

// Use DB values
$amount = (int)$pending['amount'];
$chat   = (string)$pending['chat_id'];

$data = [
    "merchant_id"  => PAYMENT_MERCHANT_ID,
    "authority"    => $authority,
    "amount"       => $amount . "0"
];

$jsonData = json_encode($data);
$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($jsonData)]);

$result = json_decode(curl_exec($ch), true);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    exit('cURL Error: ' . htmlspecialchars($err, ENT_QUOTES, 'UTF-8'));
}

if (isset($result['data']['code']) && (int)$result['data']['code'] === 100) {
    if ($pending['status'] !== 'paid') {
        // secure balance update (credit once)
        $stmt = $connect->prepare("UPDATE user SET coin = coin + ? WHERE id = ?");
        $chat_id_int = (int)$chat;
        $stmt->bind_param("ii", $amount, $chat_id_int);
        $stmt->execute();
        $stmt->close();

        $stmt2 = $connect->prepare("UPDATE pending_payments SET status='paid' WHERE authority=?");
        $stmt2->bind_param('s', $authority);
        $stmt2->execute();
        $stmt2->close();
    }

    sendmessage($chat, "✅ پرداخت شما با موفقیت تایید شد و موجودی شما به‌روزرسانی شد.");
    echo "Payment verified.";
} else {
    $error_message = $result['errors']['message'] ?? 'An unknown error occurred.';
    sendmessage($chat, "❌ پرداخت ناموفق: " . $error_message);
    echo "Payment failed: " . htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8');
}
