<?php
ob_start();
require_once __DIR__ . '/config.php';

// Config moved to config.php
$connect = db_connect();
$token = BOT_TOKEN;
if (!defined('API_KEY')) {
    define('API_KEY', BOT_TOKEN);
}
//------------------------------------------------------------------------------
if (!function_exists('bot')) {
function bot($method,$datas=[]){ // فانکشن اصلی ربات
    $url = "https://api.telegram.org/bot".API_KEY."/".$method;
    $ch = curl_init();
    // Avoid Telegram Markdown parse errors by dropping legacy 'markdown'
    if (isset($datas['parse_mode']) && is_string($datas['parse_mode']) && strtolower($datas['parse_mode']) === 'markdown') {
        unset($datas['parse_mode']);
    }
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$datas);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch,CURLOPT_TIMEOUT, 20);
    if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    }
    $res = curl_exec($ch);
    if($res === false){
        error_log('Telegram cURL error: '.curl_error($ch));
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    return json_decode($res,true);
}
}

function deleteMessage($chatid,$msgid){ //فانکشن ارسال پیام
	return bot('deleteMessage',[
	'chat_id'=>$chatid,
	'message_id'=>$msgid,
	]);
	}
//▪▪▪▪▪▪▪▪▪▪▪▪//
function SendMessage($chatid,$text,$keyboard=null,$pars='html'){ //فانکشن ارسال پیام
	return bot('sendMessage',[
	'chat_id'=>$chatid,
	'text'=>$text,
	'reply_markup'=>$keyboard,
	'parse_mode'=>$pars,
	'disable_web_page_preview'=>true 
	]);
	}
	function editMessageText($chat_id, $message_id, $text, $keyboard = null, $pars = 'html') {
    return bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'reply_markup' => $keyboard,
        'parse_mode' => $pars,
        'disable_web_page_preview' => true
    ]);
}
	function editMessageCaption($chat_id, $message_id, $text, $keyboard = null, $pars = 'html') {
    return bot('editMessageCaption', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'caption' => $text,
        'reply_markup' => $keyboard,
        'parse_mode' => $pars,
        'disable_web_page_preview' => true
    ]);
}
function updateVlessLink(string $originalLink, string $newUuid, string $newRemark): string {
    // حذف vless:// از اول لینک
    $linkWithoutScheme = substr($originalLink, 8); // حذف vless://

    // جدا کردن بخش‌های اصلی: [uuid@host:port]?[params]#[remark]
    $parts = explode('#', $linkWithoutScheme, 2);
    $beforeHash = $parts[0];
    $oldRemark = $parts[1] ?? '';

    // حالا uuid رو جدا کنیم: uuid@host:port
    $atParts = explode('@', $beforeHash, 2);
    if (count($atParts) < 2) {
        return "لینک نامعتبر است.";
    }

    $newBeforeHash = $newUuid . '@' . $atParts[1];

    // لینک نهایی رو دوباره می‌سازیم
    $updatedLink = 'vless://' . $newBeforeHash . '#' . urlencode($newRemark);

    return $updatedLink;
}

//▪▪▪▪▪▪▪▪▪▪▪▪//
function ForwardMessage($chatid,$from_chat,$message_id){ //فانکشن فروارد پیام
	bot('ForwardMessage',[
	'chat_id'=>$chatid,
	'from_chat_id'=>$from_chat,
	'message_id'=>$message_id
	]);
	}
//▪▪▪▪▪▪▪▪▪▪▪▪//
function SendPhoto($chat_id, $photo, $caption = null, $reply_markup = null){ // فانکشن ارسال عکس
	bot('SendPhoto',[
	'chat_id'=>$chat_id,
	'photo'=>$photo,
	'caption'=>$caption,
	'reply_markup'=>$reply_markup
	]);
}
function sendDocument($chat_id, $document_path, $caption = null, $pars = 'html'){
    $datas = [
        'chat_id' => $chat_id,
        'document' => new CURLFile(realpath($document_path)),
    ];
    if ($caption) {
        $datas['caption'] = $caption;
        $datas['parse_mode'] = $pars;
    }
    return bot('sendDocument', $datas);
}
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}
function getsv($url){
    $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 5,
  CURLOPT_TIMEOUT => 20,
  CURLOPT_CONNECTTIMEOUT => 10,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36
'
  ),
));
if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
}

$response = curl_exec($curl);
if ($response === false) {
    error_log('getsv cURL error: '.curl_error($curl));
    curl_close($curl);
    return null;
}

curl_close($curl);
return $response;
}
	//▪▪▪▪▪▪▪▪▪▪▪▪//
function gen_uuid() {
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        random_int( 0, 0xffff ), random_int( 0, 0xffff ),

        // 16 bits for "time_mid"
        random_int( 0, 0xffff ),

        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        random_int( 0, 0x0fff ) | 0x4000,

        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        random_int( 0, 0x3fff ) | 0x8000,

        // 48 bits for "node"
        random_int( 0, 0xffff ), random_int( 0, 0xffff ), random_int( 0, 0xffff )
    );
}

//PANELS 

/**
 * کلاسی برای مدیریت ارتباط با پنل مرزبان
 */
class MarzbanClient {
    private $base_url;
    private $token;

    public function __construct(string $base_url) {
        $this->base_url = rtrim($base_url, '/');
    }

    public function login(string $username, string $password): bool {
        $fields = ['username' => $username, 'password' => $password];
        $curl = curl_init($this->base_url . '/api/admin/token');
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($fields),
            CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded', 'accept: application/json']
        ]);
        $response = curl_exec($curl);
        if ($response === false) {
            error_log('MarzbanClient cURL Error: ' . curl_error($curl));
            curl_close($curl);
            return false;
        }
        curl_close($curl);
        $data = json_decode($response, true);
        if (isset($data['access_token'])) {
            $this->token = $data['access_token'];
            return true;
        }
        return false;
    }

    public function deleteUser(string $username): ?array {
        if (!$this->token) return null;

        $curl = curl_init($this->base_url . "/api/user/$username");
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => ['accept: application/json', 'Authorization: Bearer ' . $this->token]
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);
    }
    // ... سایر متدها مانند createUser, resetUser و ... را می‌توان به همین شکل اضافه کرد
}

//////////////////////////////////////////////MARZBAN?//////////////////////////
function convertToBytes($from) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB'];
    $number = substr($from, 0, -2);
    $suffix = strtoupper(substr($from, -2));

    if (is_numeric(substr($suffix, 0, 1))) {
        return preg_replace('/[^\d]/', '', $from);
    }

    $exponent = array_flip($units)[$suffix] ?? null;
    if ($exponent === null) {
        return null;
    }

    return $number * (1024 ** $exponent);
}

function loginPanel($address, $username, $password) {
    $fields = array('username' => $username, 'password' => $password);
    $curl = curl_init($address . '/api/admin/token');
    curl_setopt_array($curl, array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($fields),
        CURLOPT_HTTPHEADER => array('Content-Type: application/x-www-form-urlencoded', 'accept: application/json')
    ));
    $response = curl_exec($curl);
    if ($response === false) {
        error_log('cURL Error: ' . curl_error($curl));
        return null;
    }
    curl_close($curl);
    return json_decode($response, true);
}

function createService($username, $data_limit, $expire, $proxies, $token, $url) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url . '/api/user',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            'proxies' => $proxies,
            'expire' => $expire,
            'data_limit' => $data_limit,
            'username' => $username,
            'data_limit_reset_strategy' => 'no_reset'
        ]),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ),
    ));

    $response = curl_exec($curl);
    if ($response === false) {
        error_log('cURL Error: ' . curl_error($curl));
        return null;
    }
    curl_close($curl);
    return $response;
}function tamdid($username, $data_limit, $expire, $proxies, $token, $url) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url . "/api/user/$username",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'PUT',
        CURLOPT_POSTFIELDS => json_encode([
            'proxies' => $proxies,
            'expire' => $expire,
            'data_limit' => $data_limit,
            'username' => $username,
            'data_limit_reset_strategy' => 'no_reset'
        ]),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ),
    ));

    $response = curl_exec($curl);
    if ($response === false) {
        error_log('cURL Error: ' . curl_error($curl));
        return null;
    }
    curl_close($curl);
    return $response;
}
function resetUser(string $username, string $token, string $url): ?string {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => rtrim($url, '/') . "/api/user/$username/reset",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '', // درخواست POST بدون بدنه
        CURLOPT_HTTPHEADER => array(
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ),
    ));

    $response = curl_exec($curl);
    
    if ($response === false) {
        error_log('cURL Error: ' . curl_error($curl));
        curl_close($curl);
        return null;
    }

    curl_close($curl);
    return $response;
}
function deleteUser(string $username, string $token, string $url): ?string {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => rtrim($url, '/') . "/api/user/$username",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'DELETE',
        CURLOPT_HTTPHEADER => array(
            'accept: application/json',
            'Authorization: Bearer ' . $token
        ),
    ));

    $response = curl_exec($curl);
    
    if ($response === false) {
        error_log('cURL Error: ' . curl_error($curl));
        curl_close($curl);
        return null;
    }

    curl_close($curl);
    return $response;
}

function buildProxies($list, $flow = 'on') {
    $protocols = explode('|', $list);
    unset($protocols[count($protocols) - 1]); // حذف آخرین عنصر (معمولاً خالیه)
    if (empty($protocols[0])) unset($protocols[0]); // حذف عنصر اول اگه خالیه
    $proxies = [];
    foreach ($protocols as $protocol) {
        if ($protocol == 'vless' && $flow == 'on') {
            $proxies[$protocol] = ['flow' => 'xtls-rprx-vision'];
        } else {
            $proxies[$protocol] = [];
        }
    }
    return $proxies;
}
//////////////////////////////////////////////MARZBAN?//////////////////////////
//-----------------------------------------------------------------------------
// Read update safely and populate commonly used fields without notices
$rawUpdate = file_get_contents('php://input');
$update = json_decode($rawUpdate);
$update2 = json_decode($rawUpdate, true);

// Convenient shortcuts (guarded)
$message    = isset($update->message) ? $update->message : null;
$callback   = isset($update->callback_query) ? $update->callback_query : null;
$inline_q   = isset($update->inline_query) ? $update->inline_query : null;

$from_id    = isset($message->from->id) ? $message->from->id : null;
$chat_id    = isset($message->chat->id) ? $message->chat->id : null;
$membercall = isset($callback->id) ? $callback->id : null;
$message_id = isset($message->message_id) ? $message->message_id : null;
$name       = isset($message->from->first_name) ? $message->from->first_name : null;
$naeme2     = isset($callback->from->first_name) ? $callback->from->first_name : null;
$last_name  = isset($message->from->last_name) ? $message->from->last_name : null;
$username   = isset($message->from->username) ? $message->from->username : null;
$tc         = isset($message->chat->type) ? $message->chat->type : null;
$contact    = isset($message->contact) ? $message->contact : null;
$text       = isset($message->text) ? $message->text : null;
$caption    = isset($message->caption) ? $message->caption : null;
$forward_chat_username = isset($message->forward_from_chat->username) ? $message->forward_from_chat->username : null;
$chatid     = isset($callback->message->chat->id) ? $callback->message->chat->id : null;
$data       = isset($callback->data) ? $callback->data : null;
$messageid  = isset($callback->message->message_id) ? $callback->message->message_id : null;
$fromid     = isset($inline_q->from->id) ? $inline_q->from->id : null;
$inline_query = $inline_q; // keep name compatibility
$queryid    = isset($inline_q->id) ? $inline_q->id : null;
$messup     = isset($message->message_id) ? $message->message_id : null;
$rpto       = isset($message->reply_to_message->forward_from->id) ? $message->reply_to_message->forward_from->id : null;

// photo file_id (largest size if available)
$photoid = null;
if (isset($update2['message']['photo']) && is_array($update2['message']['photo']) && count($update2['message']['photo']) > 0) {
    $lastIndex = count($update2['message']['photo']) - 1;
    $photoid = $update2['message']['photo'][$lastIndex]['file_id'] ?? null;
}

// contact details (if present)
$contactid  = isset($contact->user_id) ? $contact->user_id : null;
$contactnum = isset($contact->phone_number) ? $contact->phone_number : null;

// Make available for other includes that expect this global
$GLOBALS['membercall'] = $membercall;

// استفاده از prepared statements برای جلوگیری از SQL Injection
$user = null;
if (isset($from_id)) {
    $stmt = $connect->prepare("SELECT * FROM user WHERE id = ? LIMIT 1");
    $stmt->bind_param("s", $from_id);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

$user2 = null;
if (isset($chatid)) {
    $stmt = $connect->prepare("SELECT * FROM user WHERE id = ? LIMIT 1");
    $stmt->bind_param("s", $chatid);
    $stmt->execute();
    $user2 = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

// تابع عضویت و لینک کانال از اینجا حذف و به index.php منتقل شد

//-----------------------------------------------------------------------------
$start = json_encode(['keyboard'=>[
    [['text'=>"🪪اکانت تست"]],//,['text'=>"🎁 کد تخفیف"]],
    [['text'=>'👛 کیف پول']],
    [['text'=>"🎁 دعوت دوستان"]],
    [['text'=>"♻️ تمدید سرویس"],['text'=>"🗄 سرویس ها"],['text'=>"🛒 خرید سرویس"]],
    [['text'=>"📋 تعرفه سرویس ها"]],
    [['text'=>"👤 حساب کاربری"],['text'=>"☎️ پشتیبانی"]]
],'resize_keyboard'=>true]);
$charge = json_encode(["keyboard"=>[
    [['text'=>"پرداخت ➕"],['text'=>"محاسبه 🖥"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$withdraw= json_encode(["keyboard"=>[
    [['text'=>"برداشت 📥"],['text'=>"ثبت کیف پول 💼"]],
    [['text'=>'تغییر کیف پول ⚙️']],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$tarakoneshha= json_encode(["keyboard"=>[
    [['text'=>"ثبت کیف پول 💼"]],
    [['text'=>"💹 تاریخچه"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$history=json_encode(["keyboard"=>[
    [['text'=>"تاریخچه سرمایه گذاری"]],
    [['text'=>"تاریخچه برداشت"]],
   [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
$panel=json_encode(["keyboard"=>[

[['text'=>"آمار"],['text'=>"پیام همگانی"]],
    [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);
//▪▪▪▪▪▪▪▪▪▪▪▪//
$back=json_encode(['keyboard'=>[
    [['text'=>"🔙 منو اصلی"]],
   ],'resize_keyboard'=>true]);
   $backp=json_encode(['keyboard'=>[
    [['text'=>"بازگشت به پنل"]],
   ],'resize_keyboard'=>true]);
$panel=json_encode(['keyboard'=>[
       [['text'=>"اضافه کردن سرور"],['text'=>"مدیریت سرورها"]],
       [['text'=>"مدیریت تعرفه"],['text'=>"افزودن تعرفه"]],
       [['text'=>"⚙️ مدیریت قیمت‌ها"]], // <-- دکمه جدید
       [['text'=>"آمار"],['text'=>"پیام همگانی"]],
       [['text'=>"حذف سرویس کاربر"]],
      [['text'=>"کاهش موجودی"],['text'=>"افزایش موجودی"]],
       [['text'=>"دریافت اطلاعات کاربر"],['text'=>"خاموش/روشن اد اجباری"]],
       [['text'=>"تغییر شماره کارت"]],
    [['text'=>"🔙 منو اصلی"]],
   ],'resize_keyboard'=>true]); 
   // دکمه جوین از اینجا حذف و به index.php منتقل شد
?>

