<?php
error_reporting(0);
// دریافت و تبدیل داده دریافتی از JSON
$data = json_decode(file_get_contents('php://input'), true);

// بررسی صحت اطلاعات
if (!$data || !isset($data['UserTelegramId'], $data['TronAmount'], $data['ActualTronAmount'], $data['PaymentID'])) {
    http_response_code(400);
    exit('اطلاعات ناقص است');
}

$userTelegramId = $data['UserTelegramId'];
$expectedAmount = $data['TronAmount'];
$pmid = $data['PaymentID'];

// جلوگیری از پردازش مجدد پرداخت
if (is_file("pays/$pmid")) {
    exit('Payment already processed.');
}
// ایجاد فایل برای جلوگیری از پردازش مجدد
if (!is_dir('pays')) {
    mkdir('pays', 0755, true);
}
touch("pays/$pmid");

include('class.php'); // This includes db connection and bot functions
date_default_timezone_set('Asia/Tehran');

// محاسبه تومان معادل ترون
$trx_response = file_get_contents("https://api.nobitex.ir/v2/orderbook/TRXIRT");
$trx_data = json_decode($trx_response, true);
$trx_price = isset($trx_data['lastTradePrice']) ? ($trx_data['lastTradePrice'] / 10) : 0;
$act = round($expectedAmount * $trx_price, 2);

// دریافت کد سفارش از URL
$order_code = $_GET['code'] ?? null;
if (!$order_code) {
    http_response_code(400);
    exit('Order code is missing.');
}

// --- SECURE DATABASE QUERY ---
$stmt = $connect->prepare("SELECT * FROM orders WHERE order_code = ? LIMIT 1");
$stmt->bind_param("s", $order_code);
$stmt->execute();
$order_res = $stmt->get_result();

if ($order_res->num_rows == 0) {
    // Log this error, as it might indicate a problem
    error_log("TornadoPay: Order code not found: " . $order_code);
    exit('Order not found.');
}
$order = $order_res->fetch_assoc();
$stmt->close();
// --- END OF SECURE QUERY ---

$chatid = $order['user_id'];
$size = $order['size'];
$amount = $order['amount'];
$loc = $order['location'];
$order_type = ($order['type'] == 'exten') ? 'تمدید' : 'خرید';

// پیام به کاربر
sendmessage($userTelegramId, "✅ پرداخت شما با موفقیت انجام شد!\n\n💰 مبلغ پرداخت: *$act* تومان\nبعد از تایید مدیریت، سرویس ارسال خواهد شد!", null, "markdown");

// ارسال به ادمین برای اطلاع
$admin_id = get_setting($connect, 'admin_id'); // Get admin_id from settings
if ($admin_id) {
    $keyboard = json_encode(['inline_keyboard' => [
        [['text' => "✅ تایید", 'callback_data' => "approve|$order_code"]],
        [['text' => "❌ رد", 'callback_data' => "reject|$order_code"]],
    ]]);
    
    $admin_message = "🔔 پرداخت جدید با ترون انجام شد\n\n"
                   . "👤 کاربر: [$userTelegramId](tg://user?id=$userTelegramId)\n"
                   . "💳 مبلغ: *$act* تومان\n"
                   . "🧾 کد سفارش: `$order_code`\n\n"
                   . "🔗 نوع:  $order_type\n"
                   . "👤 کاربر اصلی: `$chatid`\n"
                   . "📦 حجم: $size گیگ\n"
                   . "💸 مبلغ سفارش: " . number_format($amount) . " تومان\n"
                   . "📍 لوکیشن: $loc";

    sendmessage($admin_id, $admin_message, $keyboard, "markdown");
}

?>
